/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.listener;

import java.util.ArrayList;
import java.util.List;
import org.codefilarete.stalactite.engine.listener.DeleteListener;

public class DeleteListenerCollection<C>
implements DeleteListener<C> {
    private final List<DeleteListener<C>> deleteListeners = new ArrayList<DeleteListener<C>>();

    @Override
    public void beforeDelete(Iterable<? extends C> entities) {
        this.deleteListeners.forEach(listener -> listener.beforeDelete(entities));
    }

    @Override
    public void afterDelete(Iterable<? extends C> entities) {
        this.deleteListeners.forEach(listener -> listener.afterDelete(entities));
    }

    @Override
    public void onDeleteError(Iterable<? extends C> entities, RuntimeException runtimeException) {
        this.deleteListeners.forEach(listener -> listener.onDeleteError(entities, runtimeException));
    }

    public void add(DeleteListener<? extends C> deleteListener) {
        this.deleteListeners.add(deleteListener);
    }

    public void moveTo(DeleteListenerCollection<C> deleteListener) {
        deleteListener.deleteListeners.addAll(this.deleteListeners);
        this.deleteListeners.clear();
    }
}

